#version 420

uniform vec2 blur_direction;
uniform float intensity;

uniform sampler2D glow_texture;
uniform vec2 resolution;

in vec2 out_TexCoord;

out vec4 fragColor;

void main()
{
	vec2 pixelsize = vec2(1) / resolution;
	vec2 offset = blur_direction * pixelsize;

	vec4 pixel = vec4(0);
	pixel += texture2D(glow_texture, out_TexCoord + (offset * -10.0)) * 0.000001;
	pixel += texture2D(glow_texture, out_TexCoord + (offset * -9.0)) * 0.00001;
	pixel += texture2D(glow_texture, out_TexCoord + (offset * -8.0)) * 0.000078;
	pixel += texture2D(glow_texture, out_TexCoord + (offset * -7.0)) * 0.000489;
	pixel += texture2D(glow_texture, out_TexCoord + (offset * -6.0)) * 0.002403;
	pixel += texture2D(glow_texture, out_TexCoord + (offset * -5.0)) * 0.009245;
	pixel += texture2D(glow_texture, out_TexCoord + (offset * -4.0)) * 0.027835;
	pixel += texture2D(glow_texture, out_TexCoord + (offset * -3.0)) * 0.065591;
	pixel += texture2D(glow_texture, out_TexCoord + (offset * -2.0)) * 0.120978;
	pixel += texture2D(glow_texture, out_TexCoord + (offset * -1.0)) * 0.174666;
	pixel += texture2D(glow_texture, out_TexCoord)                   * 0.197413;
	pixel += texture2D(glow_texture, out_TexCoord + (offset *  1.0)) * 0.174666;
	pixel += texture2D(glow_texture, out_TexCoord + (offset *  2.0)) * 0.120978;
	pixel += texture2D(glow_texture, out_TexCoord + (offset *  3.0)) * 0.065591;
	pixel += texture2D(glow_texture, out_TexCoord + (offset *  4.0)) * 0.027835;
	pixel += texture2D(glow_texture, out_TexCoord + (offset *  5.0)) * 0.009245;
	pixel += texture2D(glow_texture, out_TexCoord + (offset *  6.0)) * 0.002403;
	pixel += texture2D(glow_texture, out_TexCoord + (offset *  7.0)) * 0.000489;
	pixel += texture2D(glow_texture, out_TexCoord + (offset *  8.0)) * 0.000078;
	pixel += texture2D(glow_texture, out_TexCoord + (offset *  9.0)) * 0.00001;
	pixel += texture2D(glow_texture, out_TexCoord + (offset *  10.0)) * 0.000001;
	pixel *= intensity;

	fragColor = pixel;

	// //this will be our RGBA sum
	// vec4 sum = vec4(0.0);
	
	// //our original texcoord for this fragment
	// vec2 tc = out_TexCoord;
	
	// //the amount to blur, i.e. how far off center to sample from 
	// //1.0 -> blur by one pixel
	// //2.0 -> blur by two pixels, etc.
	// float blur = 1.0;//radius/resolution; 
    
	// //the direction of our blur
	// //(1.0, 0.0) -> x-axis blur
	// //(0.0, 1.0) -> y-axis blur
	// float hstep = blur_direction.x / resolution.x;
	// float vstep = blur_direction.y / resolution.y;
    
	// //apply blurring, using a 9-tap filter with predefined gaussian weights
    
	// sum += texture2D(glow_texture, vec2(tc.x - 4.0*blur*hstep, tc.y - 4.0*blur*vstep)) * 0.0162162162;
	// sum += texture2D(glow_texture, vec2(tc.x - 3.0*blur*hstep, tc.y - 3.0*blur*vstep)) * 0.0540540541;
	// sum += texture2D(glow_texture, vec2(tc.x - 2.0*blur*hstep, tc.y - 2.0*blur*vstep)) * 0.1216216216;
	// sum += texture2D(glow_texture, vec2(tc.x - 1.0*blur*hstep, tc.y - 1.0*blur*vstep)) * 0.1945945946;
	
	// sum += texture2D(glow_texture, vec2(tc.x, tc.y)) * 0.2270270270;
	
	// sum += texture2D(glow_texture, vec2(tc.x + 1.0*blur*hstep, tc.y + 1.0*blur*vstep)) * 0.1945945946;
	// sum += texture2D(glow_texture, vec2(tc.x + 2.0*blur*hstep, tc.y + 2.0*blur*vstep)) * 0.1216216216;
	// sum += texture2D(glow_texture, vec2(tc.x + 3.0*blur*hstep, tc.y + 3.0*blur*vstep)) * 0.0540540541;
	// sum += texture2D(glow_texture, vec2(tc.x + 4.0*blur*hstep, tc.y + 4.0*blur*vstep)) * 0.0162162162;



	// sum += texture2D(glow_texture,out_TexCoord);
	// fragColor = sum;
}